// GpList.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpList Dialog


CGpList::CGpList(CWnd* pParent /*=NULL*/)
//	: CDialog(CGpList::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpList)
	//}}AFX_DATA_INIT
}


void CGpList::DoDataExchange(CDataExchange* pDX)
{
	CDialogBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpList)
	DDX_Control(pDX, IDC_NodeTree, m_NodeTree);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpList, CDialogBar)
	//{{AFX_MSG_MAP(CGpList)
	ON_WM_SIZE()
	ON_NOTIFY(NM_DBLCLK, IDC_NodeTree, OnDblclkNodeTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpList Message Handler
CSize CGpList::CalcDynamicLayout( int nLength, DWORD dwMode )
{
	CRect Rect ;
	theApp.m_pMainFrame->GetClientRect(&Rect) ;
	CSize sz(200,Rect.Height()-60) ;
	return sz ;
}

void CGpList::OnSize(UINT nType, int cx, int cy) 
{
	CDialogBar::OnSize(nType, cx, cy);
	
	CWnd* pNodeTree = GetDlgItem( IDC_NodeTree );
	
	if( pNodeTree ){
		pNodeTree->MoveWindow(5,5,cx-10,cy-10) ;
	}
	InvalidateRect( NULL);  
}


BOOL CGpList::OnInitDialog() 
{
	//	Create image list for nodes
	m_NodeImageList.Create(IDB_NodeImageList,18,1,RGB(0,255,0)); // The icon is made as a background color with green
	m_NodeTree.SetImageList(&m_NodeImageList,TVSIL_NORMAL);

	//	Only a top item makes tree view data for GP Node(Do not perform a network search)
	MakeNodeList( TRUE ) ;

	return( TRUE );
}


  
//
//	Create the data of tree view for GP nodes
//
//  Input bTopItemOnly : TRUE   Only create the top item(Do not perform a network search)
//                       FALSE 
//

void CGpList::MakeNodeList(BOOL bTopItemOnly /* =FALSE */)
{
	m_NodeTree.SelectItem(NULL);
	
	//	delete all of the items
	m_NodeTree.DeleteAllItems() ;


	//	set the item for serch network on the top
	HTREEITEM hTop = m_NodeTree.InsertItem("GP NetWork",0,1,TVI_ROOT,TVI_SORT) ;
	m_NodeTree.SetItemData(hTop,GPLIST_FINDITEM) ;

	if(bTopItemOnly){
		return ;			//	if only top. return here
	}

	//	Serch node is sample for async mode
	theApp.ASyncModeEnable() ;

	//	Show the dialog for Serch Nodes.
	m_pFindNodeDlg = new CFindNodeDlg ;

	//	Using the CMSock for Broadcast, serch the GP on the network
	int iError = theApp.MtoMFS_FindNode( _T("255.255.255.255") );

	if( iError != MTOM_CONTINUE ){
		//	cannot start cause the error is happend
		theApp.OnFinished( iError );
	}
} 

//
//	The serch is finished
//	Not checking the what process is finished, cause this apprication
//	use async mode only serch nodes.
//   
BOOL CGpMApp::OnFinished(int iError)
{
	if( iError != MTOM_CONTINUE ){
		//	Finished

		//	change to sync mode
		SyncModeEnable();

		m_pMainFrame->m_wndGpList.FindNodeEnd(iError,MtoMGetLastError() ) ;	//	main frame
	} else {
		//	the process is continue
	}
	return( TRUE );
}

//
//	Finished the serch node 
//
void CGpList::FindNodeEnd(int iError,DWORD dwParticulars)
{
	HTREEITEM hNode ;

	//	Hide the dialog for serch node
	m_pFindNodeDlg->PostMessage(WM_CLOSE) ;

	HTREEITEM hTop = m_NodeTree.GetRootItem( );

	if( iError ){
		hNode = m_NodeTree.InsertItem("Error",4,5,hTop,TVI_LAST) ;
		m_NodeTree.SetItemData(hNode,GPLIST_MESSAGE) ; //  Message item
		DispMtoMError(iError, dwParticulars);
		m_NodeTree.Expand(hTop,TVE_EXPAND); //  Open the list
		return ;
	}	
	
	//	the result is tanked to the Network information area
	LPGPNETWORKDATA pNetWorkData = theApp.GetGPNetWorkData();

	BYTE *p ;
	int iFindCount = 0 ;
	static CString wk ;
	for( DWORD i = 0 ; i < pNetWorkData->dwNodeCounter ; i++){
		if( pNetWorkData->Node[i].dwNodeStatus == B_dwNodeStatus_Find ){
			// The node exist.
	
			pNetWorkData->Node[i].dwCheckButton = TRUE ;
	
			//	Convert IP address to string
			p = (BYTE *)&pNetWorkData->Node[i].dwIPAddress ;
			wk.Format("%d.%d.%d.%d",p[3],p[2],p[1],p[0] ) ;
						
			hNode = m_NodeTree.InsertItem(wk,2,3,hTop,TVI_SORT) ;
			m_NodeTree.SetItemData(hNode,GPLIST_NODEITEM) ;
			iFindCount++ ;
		}
	}


	if( iFindCount == 0 ){
		// Node is none
		hNode = m_NodeTree.InsertItem("Nothing",4,5,hTop,TVI_LAST) ;
		m_NodeTree.SetItemData(hNode,GPLIST_MESSAGE) ; //  MessageItem
	}

	m_NodeTree.Expand(hTop,TVE_EXPAND); //  Open the list
} 




void CGpList::OnDblclkNodeTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	static CString szItem ;
	CGpMDoc *pDoc ;
	POSITION pos ;

	// Serch the item now selected
	HTREEITEM hItem = m_NodeTree.GetNextItem( NULL,TVGN_CARET) ;

	if( hItem ){
		switch( m_NodeTree.GetItemData(hItem )){
			case GPLIST_FINDITEM:			// the item for serch node.
				MakeNodeList();				// Serch nodes

				InvalidateRect( NULL);			
				break ;

			case GPLIST_NODEITEM:	// Node item
  
				szItem = m_NodeTree.GetItemText( hItem ) ;

				// Check the document linked the node
				if( pDoc = GetIPAddressLinkedDocument(szItem)){
					//	Active the view linked
					pos = pDoc->GetFirstViewPosition();
					theApp.m_pMainFrame->MDIActivate( pDoc->GetNextView( pos )->GetParentFrame() );
				} else {
					// none
					//	open the new document with selected node
					theApp.m_szOpenDocmentIPAddress = szItem ;  // Set the linked item
					theApp.CallOnFileNew();
					theApp.m_szOpenDocmentIPAddress = NULL ;	// Delete the linked item, cause already create the document
				}
				break ;

			case GPLIST_MESSAGE:	// MessageItem
				break ;
						
		}
	}
	*pResult = 0;
}



